//level structure

//goals

//triggers
var max_triggers = 10;



var levels = new Array();
var max_levels = 10;

for (i=0;i<max_levels;i++)
{
	levels[i] = new Object();
	levels[i].parts = new Array();
	for (j=0;j<max_particles;j++)
		levels[i].parts[j] = new Object();

	levels[i].trigger = new Array();
	for (j=0;j<max_triggers;j++)
		levels[i].trigger[j] = new Object();
}

levels[0].width = GetScreenWidth();
levels[0].height = GetScreenHeight();
levels[0].parts_num = 17;
levels[0].player_will = 1;
levels[0].player_will_max = 100;
levels[0].max_layers = 0;
levels[0].gravity_req = 62;
levels[0].parts[0].x = GetScreenWidth()/2;
levels[0].parts[0].y = GetScreenHeight()/2;
levels[0].parts[0].vx = 0;
levels[0].parts[0].vy = 0;

levels[0].parts[1].will = 1;
levels[0].parts[2].will = 3;
levels[0].parts[3].will = 6;
levels[0].parts[4].will = 10;
levels[0].parts[5].will = 20;
levels[0].parts[6].will = 30;
levels[0].parts[7].will = 60;
levels[0].parts[8].will = 20;
levels[0].parts[9].will = 20;
levels[0].parts[10].will = 50;
levels[0].parts[11].will = 50;
levels[0].parts[12].will = 50;
levels[0].parts[13].will = 100
levels[0].parts[14].will = 100;
levels[0].parts[15].will = 100;
levels[0].parts[16].will = 0.5;

levels[0].parts[1].active = true;
levels[0].parts[1].x = 3*GetScreenWidth()/4;
levels[0].parts[1].y = GetScreenHeight()/2;
levels[0].parts[2].active = false;
levels[0].parts[3].active = false;
levels[0].parts[4].active = false;
levels[0].parts[5].active = false;
levels[0].parts[6].active = false;
levels[0].parts[7].active = false;
levels[0].parts[8].active = false;
levels[0].parts[9].active = false;
levels[0].parts[10].active = false;
levels[0].parts[11].active = false;
levels[0].parts[12].active = false;
levels[0].parts[13].active = false;
levels[0].parts[14].active = false;
levels[0].parts[15].active = false;
levels[0].parts[16].active = false;
levels[0].parts[16].x = 3*8*GetScreenWidth()/2;
levels[0].parts[16].y = GetScreenHeight()/2;

levels[0].parts[4].vx = 6;
levels[0].parts[4].vy = 3;
levels[0].parts[5].vx = 0;
levels[0].parts[16].vy = 1;

levels[0].trigger[0].text = "Welcome to the tutorial, here we explain the basics about The Particle of Infinite Free Will.\n\nYou are the grey particle in the center of the screen (you're very high right now... it makes sense... really).";//\n\nTo move the particle, use the W, A, S, and D keys to move, SPACE to stop, while using the mouse to move the cursor around the screen.";
levels[0].trigger[0].cond_type = "time";
levels[0].trigger[0].trig_type = "text";
levels[0].trigger[0].cond_value = 20;
levels[0].trigger[0].script = "";

levels[0].trigger[1].text = "As you can see, the universe is pretty trippy and chaotic, and your goal is to restore order in the given universe.\n\nTo do this, collect the free will from the other roaming particles.  This is done by just moving the mouse cursor close enough to the particle.\n\nMove the cursor to the other particle to collect its free will.";
levels[0].trigger[1].trig_type = "text";
levels[0].trigger[1].cond_type = "time";
levels[0].trigger[1].cond_value = 10;
levels[0].trigger[1].script = "";

levels[0].trigger[2].text = "Devoid of its free will, the particle travels in an orderly manner, and loses its colour and shape.\n\nIncreasing your free will gives you additional abilities.  For example, the higher your will, the slower other particles will seem to move, allowing you to collect more.\n\nCollect the will from some of the slower particles before going on to collecting from the faster ones.";
levels[0].trigger[2].trig_type = "text";
levels[0].trigger[2].cond_type = "kill";
levels[0].trigger[2].cond_value = 1;
levels[0].trigger[2].script = "for(i=2;i<8;i++){parts[i].active = true;}";

levels[0].trigger[3].text = "The minimap in the top right of the screen will tell you where you are (the bigger dot) in the world.  It'll also tell you where the other particles are and roughly how fast they're moving.  Use the WASD keys to move your big particle over and collect the will from the other slower particles first and then the faster ones.\n\nYour particle will keep moving in the direction it's headed in, but if you wish, you can press the SPACE bar to stop.";
levels[0].trigger[3].trig_type = "text";
levels[0].trigger[3].cond_type = "kill";
levels[0].trigger[3].cond_value = 7;
levels[0].trigger[3].script = "field_w*=3; field_h*=3; parts[0].vx = 0; parts[0].vy = 0; for(i=8;i<16;i++){parts[i].active = true;parts[i].x = field_w*Math.random(); parts[i].y = field_h*Math.random();}";


levels[0].trigger[4].text = "It looks like there's one more particle left.  You can use the WASD keys to move over to it, but at this point you have collected enough free will in this level to allow you to modify the universe to help you.  Holding the LEFT MOUSE BUTTON will add gravity to your particle and pull the other particle towards you.\n\nHold the LEFT MOUSE BUTTON and pull the other particle to you so you can collect its will.";
levels[0].trigger[4].trig_type = "text";
levels[0].trigger[4].cond_type = "kill";
levels[0].trigger[4].cond_value = 15;
levels[0].trigger[4].script = "parts[16].active = true; parts[0].vx = 0; parts[0].vy = 0;field_w*=5; field_h*=5; parts[i].vx = 0; parts[i].vy = 0;";

				//require a field change.


levels[0].trigger[5].text = "Gravity is particularly useful when there are only a few particles remaining, usually travelling at high speeds.  Even though using gravity does not reduce the free will you have collected, just keeping the mouse button held all the time may not be the best strategy...\n\nExerting your will on the universe will be important for collecting more free will. This will become more apparent as you progress through all seven levels.\n\n";
levels[0].trigger[5].trig_type = "text";
levels[0].trigger[5].cond_type = "kill";
levels[0].trigger[5].cond_value = 16;
levels[0].trigger[5].script = "";

levels[0].trigger[6].text = "Now that you have collected enough free will, you will now proceed onto the next level.\n\nGood luck!!\n\n\n\nIf you wish to end the trip, you can always press ESCAPE to quit the game.";
levels[0].trigger[6].trig_type = "text";
levels[0].trigger[6].cond_type = "time";
levels[0].trigger[6].cond_value = 1;
levels[0].trigger[6].script = "";

levels[0].trigger[7].text = "";
levels[0].trigger[7].trig_type = "exit";
levels[0].trigger[7].cond_type = "time";
levels[0].trigger[7].cond_value = 1;
levels[0].trigger[7].script = "";
			
			
			
			
levels[1].width = 4*GetScreenWidth();
levels[1].height = 4*GetScreenHeight();
levels[1].parts_num = 9;
levels[1].player_will = 1;
levels[1].player_will_max = 20;
levels[1].max_layers = 0;
levels[1].gravity_req = 10;
levels[1].parts[0].x = GetScreenWidth()/2;
levels[1].parts[0].y = GetScreenHeight()/2;
levels[1].parts[0].vx = 0;
levels[1].parts[0].vy = 0;

levels[1].parts[1].will = 1;
levels[1].parts[2].will = 3;
levels[1].parts[3].will = 3;
levels[1].parts[4].will = 5;
levels[1].parts[5].will = 5;
levels[1].parts[6].will = 12;
levels[1].parts[7].will = 12;
levels[1].parts[8].will = 32;

			
levels[1].trigger[0].text = "";
levels[1].trigger[0].trig_type = "exit";
levels[1].trigger[0].cond_type = "kill";
levels[1].trigger[0].cond_value = 8;
levels[1].trigger[0].script = "";
			 
			
			 


levels[2].width = 4*GetScreenWidth();
levels[2].height = 4*GetScreenHeight();
levels[2].parts_num = 20;
levels[2].player_will = 1;
levels[2].player_will_max = 97;
levels[2].max_layers = 0;
levels[2].gravity_req = 45;
levels[2].parts[0].x = GetScreenWidth()/2;
levels[2].parts[0].y = GetScreenHeight()/2;
levels[2].parts[0].vx = 0;
levels[2].parts[0].vy = 0;

levels[2].parts[1].will = 1;
levels[2].parts[2].will = 3;
levels[2].parts[3].will = 3;
levels[2].parts[4].will = 5;
levels[2].parts[5].will = 5;
levels[2].parts[6].will = 12;
levels[2].parts[7].will = 12;
levels[2].parts[8].will = 32;
levels[2].parts[9].will = 32;
levels[2].parts[10].will = 64;
levels[2].parts[11].will = 64;
levels[2].parts[12].will = 128;
levels[2].parts[13].will = 128;
levels[2].parts[14].will = 128;
levels[2].parts[15].will = 128;
levels[2].parts[16].will = 256;
levels[2].parts[17].will = 256;
levels[2].parts[18].will = 256;
levels[2].parts[19].will = 256;

levels[2].trigger[0].text = "";
levels[2].trigger[0].trig_type = "script";
levels[2].trigger[0].cond_type = "time";
levels[2].trigger[0].cond_value = 360;
levels[2].trigger[0].script = "curr_word2 = \"IT'S THE SHROOMS\";";

			
levels[2].trigger[1].text = "";
levels[2].trigger[1].trig_type = "exit";
levels[2].trigger[1].cond_type = "kill";
levels[2].trigger[1].cond_value = 19;
levels[2].trigger[1].script = "";

levels[3].width = 2*GetScreenWidth();
levels[3].height = 2*GetScreenHeight();
levels[3].parts_num = 10;
levels[3].player_will = 1;
levels[3].player_will_max = 25;
levels[3].max_layers = 10;
levels[3].gravity_req = 15;
levels[3].parts[0].x = GetScreenWidth()/2;
levels[3].parts[0].y = GetScreenHeight()/2;
levels[3].parts[0].vx = 0;
levels[3].parts[0].vy = 0;


levels[3].parts[1].will = 1;
levels[3].parts[2].will = 3;
levels[3].parts[3].will = 3;
levels[3].parts[4].will = 5;
levels[3].parts[5].will = 5;
levels[3].parts[6].will = 12;
levels[3].parts[7].will = 12;
levels[3].parts[8].will = 32;
levels[3].parts[9].will = 32;

levels[3].parts[1].layer = 10;
levels[3].parts[2].layer = 10;
levels[3].parts[3].layer = 10;
levels[3].parts[4].layer = 10;
levels[3].parts[5].layer = 10;
levels[3].parts[6].layer = 10;
levels[3].parts[7].layer = 10;
levels[3].parts[8].layer = 10;
levels[3].parts[9].layer = 10;


levels[3].trigger[0].text = "";
levels[3].trigger[0].trig_type = "script";
levels[3].trigger[0].cond_type = "time";
levels[3].trigger[0].cond_value = 0;
levels[3].trigger[0].script = "curr_word = 'FIND THE PARTICLES'";
			
levels[3].trigger[1].text = "";
levels[3].trigger[1].trig_type = "script";
levels[3].trigger[1].cond_type = "time";
levels[3].trigger[1].cond_value = 260;
levels[3].trigger[1].script = "curr_word = 'ZOOM IN'";

levels[3].trigger[2].text = "";
levels[3].trigger[2].trig_type = "exit";
levels[3].trigger[2].cond_type = "kill";
levels[3].trigger[2].cond_value = 9;
levels[3].trigger[2].script = "";





levels[4].width = 4*GetScreenWidth();
levels[4].height = 4*GetScreenHeight();
levels[4].parts_num = 20;
levels[4].player_will = 1;
levels[4].player_will_max = 95;
levels[4].max_layers = 10;
levels[4].gravity_req = 35;
levels[4].parts[0].x = GetScreenWidth()/2;
levels[4].parts[0].y = GetScreenHeight()/2;
levels[4].parts[0].vx = 0;
levels[4].parts[0].vy = 0;

levels[4].parts[1].will = 1;
levels[4].parts[1].layer = 0;
levels[4].parts[2].will = 1;
levels[4].parts[2].layer = 0;
levels[4].parts[3].will = 1;
levels[4].parts[3].layer = 0;
levels[4].parts[4].will = 5;
levels[4].parts[4].layer = 10;
levels[4].parts[5].will = 5;
levels[4].parts[5].layer = 10;
levels[4].parts[6].will = 5;
levels[4].parts[6].layer = 10;
levels[4].parts[7].will = 5;
levels[4].parts[7].layer = 10;
levels[4].parts[8].will = 64;
levels[4].parts[8].layer = 0;
levels[4].parts[9].will = 64;
levels[4].parts[9].layer = 0;
levels[4].parts[10].will = 64;
levels[4].parts[10].layer = 0;
levels[4].parts[11].will = 64;
levels[4].parts[11].layer = 0;
levels[4].parts[12].will = 128;
levels[4].parts[12].layer = 10;
levels[4].parts[13].will = 128;
levels[4].parts[13].layer = 10;
levels[4].parts[14].will = 128;
levels[4].parts[14].layer = 10;
levels[4].parts[15].will = 128;
levels[4].parts[15].layer = 10;
levels[4].parts[16].will = 256;
levels[4].parts[16].layer = 10;
levels[4].parts[17].will = 256;
levels[4].parts[18].layer = 10;
levels[4].parts[18].will = 256;
levels[4].parts[19].layer = 0;
levels[4].parts[19].will = 256;
			
levels[4].trigger[0].text = "";
levels[4].trigger[0].trig_type = "exit";
levels[4].trigger[0].cond_type = "kill";
levels[4].trigger[0].cond_value = 19;
levels[4].trigger[0].script = "";






























levels[5].width = 3*GetScreenWidth();
levels[5].height = 3*GetScreenHeight();
levels[5].parts_num = 20;
levels[5].player_will = 1;
levels[5].player_will_max = 92;
levels[5].max_layers = 10;
levels[5].gravity_req = 25;
levels[5].time = 5000;
levels[5].max_time = 10000;
levels[5].parts[0].x = GetScreenWidth()/2;
levels[5].parts[0].y = GetScreenHeight()/2;
levels[5].parts[0].vx = 0;
levels[5].parts[0].vy = 0;

levels[5].parts[1].will = 1;
levels[5].parts[1].layer = 0;
levels[5].parts[1].time_s = 0;
levels[5].parts[1].time_e = -1;

levels[5].parts[2].will = 1;
levels[5].parts[2].layer = 0;
levels[5].parts[2].time_s = 0;
levels[5].parts[2].time_e = -1;

levels[5].parts[3].will = 1;
levels[5].parts[3].layer = 0;
levels[5].parts[3].time_s = 0;
levels[5].parts[3].time_e = -1;

levels[5].parts[4].will = 1;
levels[5].parts[4].layer = 10;
levels[5].parts[4].time_s = 0;
levels[5].parts[4].time_e = -1;

levels[5].parts[5].will = 5;
levels[5].parts[5].layer = 10;
levels[5].parts[5].time_s = 0;
levels[5].parts[5].time_e = -1;

levels[5].parts[6].will = 5;
levels[5].parts[6].layer = 10;
levels[5].parts[6].time_s = 0;
levels[5].parts[6].time_e = -1;

levels[5].parts[7].will = 5;
levels[5].parts[7].layer = 10;
levels[5].parts[7].time_s = 0;
levels[5].parts[7].time_e = -1;

levels[5].parts[8].will = 25;
levels[5].parts[8].layer = 0;
levels[5].parts[8].time_s = 0;
levels[5].parts[8].time_e = -1;


//back in time particles

levels[5].parts[9].will = 20;
levels[5].parts[9].layer = 0;
levels[5].parts[9].time_s = 0;
levels[5].parts[9].time_e = 4999;

levels[5].parts[10].will = 20;
levels[5].parts[10].layer = 0;
levels[5].parts[10].time_s = 0;
levels[5].parts[10].time_e = 4999;

levels[5].parts[11].will = 32;
levels[5].parts[11].layer = 0;
levels[5].parts[11].time_s = 0;
levels[5].parts[11].time_e = 4999;

levels[5].parts[12].will = 64;
levels[5].parts[12].layer = 10;
levels[5].parts[12].time_s = 0;
levels[5].parts[12].time_e = 4999;

levels[5].parts[13].will = 64;
levels[5].parts[13].layer = 10;
levels[5].parts[13].time_s = 0;
levels[5].parts[13].time_e = 4999;

levels[5].parts[14].will = 64;
levels[5].parts[14].layer = 10;
levels[5].parts[14].time_s = 0;
levels[5].parts[14].time_e = 4999;

levels[5].parts[15].will = 128;
levels[5].parts[15].layer = 10;
levels[5].parts[15].time_s = 0;
levels[5].parts[15].time_e = 4999;

levels[5].parts[16].will = 128;
levels[5].parts[16].layer = 10;
levels[5].parts[16].time_s = 0;
levels[5].parts[16].time_e = 4999;

levels[5].parts[17].will = 128;
levels[5].parts[17].layer = 0;
levels[5].parts[17].time_s = 0;
levels[5].parts[17].time_e = 4999;

levels[5].parts[18].layer = 10;
levels[5].parts[18].will = 256;
levels[5].parts[18].time_s = 0;
levels[5].parts[18].time_e = 4999;

levels[5].parts[19].layer = 0;
levels[5].parts[19].will = 256;
levels[5].parts[19].time_s = 0;
levels[5].parts[19].time_e = 4999;

levels[5].trigger[0].text = "";
levels[5].trigger[0].trig_type = "script";
levels[5].trigger[0].cond_type = "time";
levels[5].trigger[0].cond_value = 0;
levels[5].trigger[0].script = "curr_word = ''";
			
levels[5].trigger[1].text = "";
levels[5].trigger[1].trig_type = "script";
levels[5].trigger[1].cond_type = "kill";
levels[5].trigger[1].cond_value = 8;
levels[5].trigger[1].script = "curr_word = 'WHERE ARE THEY?';";

levels[5].trigger[2].text = "";
levels[5].trigger[2].trig_type = "script";
levels[5].trigger[2].cond_type = "time";
levels[5].trigger[2].cond_value = 80;
levels[5].trigger[2].script = "curr_word = 'CHECK THE TIME'";

levels[5].trigger[3].text = "";
levels[5].trigger[3].trig_type = "script";
levels[5].trigger[3].cond_type = "time";
levels[5].trigger[3].cond_value = 200;
levels[5].trigger[3].script = "curr_word = 'GO BACK IN TIME!'";

levels[5].trigger[4].text = "";
levels[5].trigger[4].trig_type = "exit";
levels[5].trigger[4].cond_type = "kill";
levels[5].trigger[4].cond_value = 19;
levels[5].trigger[4].script = "";


levels[6].width = 3*GetScreenWidth();
levels[6].height = 3*GetScreenHeight();
levels[6].parts_num = 34;
levels[6].player_will = 1;
levels[6].player_will_max = 220;
levels[6].max_layers = 10;
levels[6].gravity_req = 100;
levels[6].time = 0;
levels[6].max_time = 10000;
levels[6].parts[0].x = GetScreenWidth()/2;
levels[6].parts[0].y = GetScreenHeight()/2;
levels[6].parts[0].vx = 0;
levels[6].parts[0].vy = 0;

levels[6].parts[1].will = 2;
levels[6].parts[1].layer = 0;
levels[6].parts[1].time_s = 6999;
levels[6].parts[1].time_e = -1;

levels[6].parts[2].will = 2;
levels[6].parts[2].layer = 10;
levels[6].parts[2].time_s = 6999;
levels[6].parts[2].time_e = -1;

levels[6].parts[3].will = 3;
levels[6].parts[3].layer = 0;
levels[6].parts[3].time_s = 6999;
levels[6].parts[3].time_e = -1;

levels[6].parts[4].will = 5;
levels[6].parts[4].layer = 10;
levels[6].parts[4].time_s = 6999
levels[6].parts[4].time_e = -1;

levels[6].parts[5].will = 5;
levels[6].parts[5].layer = 0;
levels[6].parts[5].time_s = 6999;
levels[6].parts[5].time_e = -1;

levels[6].parts[6].will = 5;
levels[6].parts[6].layer = 10;
levels[6].parts[6].time_s = 6999;
levels[6].parts[6].time_e = -1

levels[6].parts[7].will = 5;
levels[6].parts[7].layer = 0;
levels[6].parts[7].time_s = 6999;
levels[6].parts[7].time_e = -1

levels[6].parts[8].will = 64;
levels[6].parts[8].layer = 10;
levels[6].parts[8].time_s = 6999;
levels[6].parts[8].time_e = -1

levels[6].parts[9].will = 64;
levels[6].parts[9].layer = 0;
levels[6].parts[9].time_s = 6999;
levels[6].parts[9].time_e = -1;

levels[6].parts[10].will = 64;
levels[6].parts[10].layer = 10;
levels[6].parts[10].time_s = 1000;
levels[6].parts[10].time_e = 4999;

levels[6].parts[11].will = 64;
levels[6].parts[11].layer = 0;
levels[6].parts[11].time_s = 1000;
levels[6].parts[11].time_e = 4999;

levels[6].parts[12].will = 128;
levels[6].parts[12].layer = 10;
levels[6].parts[12].time_s = 1000;
levels[6].parts[12].time_e = 4999;

levels[6].parts[13].will = 128;
levels[6].parts[13].layer = 0;
levels[6].parts[13].time_s = 1000;
levels[6].parts[13].time_e = 4999;

levels[6].parts[14].will = 128;
levels[6].parts[14].layer = 10;
levels[6].parts[14].time_s = 1000;
levels[6].parts[14].time_e = 4999;

levels[6].parts[15].will = 128;
levels[6].parts[15].layer = 0;
levels[6].parts[15].time_s = 1000;
levels[6].parts[15].time_e = 4999;

levels[6].parts[16].will = 256;
levels[6].parts[16].layer = 10;
levels[6].parts[16].time_s = 1000;
levels[6].parts[16].time_e = 4999;

levels[6].parts[17].will = 256;
levels[6].parts[17].layer = 0;
levels[6].parts[17].time_s = 1000;
levels[6].parts[17].time_e = 4999;

levels[6].parts[18].layer = 10;
levels[6].parts[18].will = 256;
levels[6].parts[18].time_s = 1000;
levels[6].parts[18].time_e = 4999;

levels[6].parts[19].layer = 0;
levels[6].parts[19].will = 256;
levels[6].parts[19].time_s = 4000;
levels[6].parts[19].time_e = 7999;

levels[6].parts[20].will = 512;
levels[6].parts[20].layer = 10;
levels[6].parts[20].time_s = 4000;
levels[6].parts[20].time_e = 7999;

levels[6].parts[21].will = 512;
levels[6].parts[21].layer = 0;
levels[6].parts[21].time_s = 4000;
levels[6].parts[21].time_e = 7999;

levels[6].parts[22].will = 512;
levels[6].parts[22].layer = 10;
levels[6].parts[22].time_s = 4000;
levels[6].parts[22].time_e = 7999;

levels[6].parts[23].will = 1024;
levels[6].parts[23].layer = 0;
levels[6].parts[23].time_s = 4000;
levels[6].parts[23].time_e = 7999;

levels[6].parts[24].will = 1024;
levels[6].parts[24].layer = 10;
levels[6].parts[24].time_s = 4000;
levels[6].parts[24].time_e = 7999;

levels[6].parts[25].will = 1024;
levels[6].parts[25].layer = 0;
levels[6].parts[25].time_s = 4000;
levels[6].parts[25].time_e = 7999;

levels[6].parts[26].will = 1500;
levels[6].parts[26].layer = 10;
levels[6].parts[26].time_s = 4000;
levels[6].parts[26].time_e = 7999;

levels[6].parts[27].will = 1500;
levels[6].parts[27].layer = 0;
levels[6].parts[27].time_s = 4000;
levels[6].parts[27].time_e = 7999;

levels[6].parts[28].layer = 10;
levels[6].parts[28].will = 2048;
levels[6].parts[28].time_s = 4000;
levels[6].parts[28].time_e = 7999;

levels[6].parts[29].layer = 0;
levels[6].parts[29].will = 2048;
levels[6].parts[29].time_s = 4000;
levels[6].parts[29].time_e = 7999;

levels[6].parts[30].will = 64;
levels[6].parts[30].layer = 0;
levels[6].parts[30].time_s = 6999;
levels[6].parts[30].time_e = -1;

levels[6].parts[31].will = 64;
levels[6].parts[31].layer = 0;
levels[6].parts[31].time_s = 6999;
levels[6].parts[31].time_e = -1;

levels[6].parts[32].will = 64;
levels[6].parts[32].layer = 0;
levels[6].parts[32].time_s = 6999;
levels[6].parts[32].time_e = -1;

levels[6].parts[33].will = 64;
levels[6].parts[33].layer = 0;
levels[6].parts[33].time_s = 6999;
levels[6].parts[33].time_e = -1;


levels[6].trigger[0].text = "";
levels[6].trigger[0].trig_type = "script";
levels[6].trigger[0].cond_type = "kill";
levels[6].trigger[0].cond_value = 33;
levels[6].trigger[0].script = "curr_word2 = 'YOU WIN!!'";


levels[6].trigger[1].text = "";
levels[6].trigger[1].trig_type = "end";
levels[6].trigger[1].cond_type = "time";
levels[6].trigger[1].cond_value = 140;
levels[6].trigger[1].script = "";




			
function DrawLevel()
{
	var scale = 2;
	var text = "LEVEL "+(curr_level+1);
	font2.setColorMask(HueToColor((counter/10)%6,128));
	buffer[2].drawZoomedText(font2, GetScreenWidth()/2-scale*font2.getStringWidth(text)/2, GetScreenHeight()/2-scale*font2.getHeight()/2, scale, text);

}




var curr_time = 0;
var max_time = 10000;
var time_bar = false;

function IsParticleInTime(o)
{
	if (o==0)
		return true;
	if (curr_time >= parts[o].time_s && curr_time <= parts[o].time_e)
	{
		return true;
	}
	return false;
}

function LoadLevel(num)
{
	premx=GetMouseX();
	premy=GetMouseY();


	time_bar = true;
	curr_word = "";
	//clear old info;
	for (i=0;i<max_particles;i++)
	{
		parts[i].active = false;
	}
	counter = 0;
	player_layer = 0;
	lasttrigger = 0;
	lasttrigger_count = 0;

	field_w = levels[num].width;
	field_h = levels[num].height;
	max_layers = levels[num].max_layers;
	gravity_req = levels[num].gravity_req;
	if (levels[num].time == undefined)
		curr_time = 0;
	else
		curr_time = levels[num].time;
		
	if (levels[num].max_time == undefined)
		max_time = 10000;
	else
	{
		time_bar = true;
		max_time = levels[num].max_time;
	}

	for (i=0;i<levels[num].parts_num;i++)
	{
		parts[i].active = true;
	
		if (levels[num].parts[i].x != undefined)
			parts[i].x = levels[num].parts[i].x;
		else
			parts[i].x = field_w*Math.random();

		if (levels[num].parts[i].y != undefined)
			parts[i].y = levels[num].parts[i].y;
		else
			parts[i].y = field_h*Math.random();

		parts[i].will = levels[num].parts[i].will;

		
		if (levels[num].parts[i].vx != undefined)
			parts[i].vx = levels[num].parts[i].vx;
		else
			parts[i].vx = 4*(Math.random()-0.5);
		if (levels[num].parts[i].vy != undefined)
			parts[i].vy = levels[num].parts[i].vy;
		else
			parts[i].vy = 4*(Math.random()-0.5);
		
		if (levels[num].parts[i].time_s != undefined)
		{
			parts[i].time_s = levels[num].parts[i].time_s;
		}
		else
			parts[i].time_s = 0;
		
		if (levels[num].parts[i].time_e > 0)
			parts[i].time_e = levels[num].parts[i].time_e;
		else
			parts[i].time_e = max_time;

		
		if (levels[num].parts[i].active != undefined)
			parts[i].active = levels[num].parts[i].active;
		else
			parts[i].active = true;

		if (levels[num].parts[i].layer != undefined)
			parts[i].layer = levels[num].parts[i].layer;
		else
			parts[i].layer = 0;

		player_will_max = levels[num].player_will_max;
		player_will = levels[num].player_will;
		parts[0].will = 0;		

	}
	camx = (parts[0].x-GetScreenWidth()/2);
	camy = (parts[0].y-GetScreenHeight()/2);
	
	for (i=0;i<max_clocks;i++)
	{
		clock[i].active = false;
	}
}

var lasttrigger = 0;
var lasttrigger_count = 0;


function UpdateTriggers()
{
	var activate = false;
	if (levels[curr_level].trigger[lasttrigger].cond_type == "time")
	{
		if (counter > lasttrigger_count + levels[curr_level].trigger[lasttrigger].cond_value)
		{
			activate = true;
			//trigger it!
		}
	}
	else if (levels[curr_level].trigger[lasttrigger].cond_type == "kill")
	{
		activate = true;
		for (l=1;l<levels[curr_level].trigger[lasttrigger].cond_value+1;l++)
		{
			if (parts[l].will > 0)
				activate = false;
		}
	}

	if (activate == true)
	{
		if (levels[curr_level].trigger[lasttrigger].trig_type == "text")
		{
			DisplayText(levels[curr_level].trigger[lasttrigger].text);
		}
		if (levels[curr_level].trigger[lasttrigger].script != "")
		{
			DoScript(levels[curr_level].trigger[lasttrigger].script);
		}
		if (levels[curr_level].trigger[lasttrigger].trig_type == "exit")
		{
			change_level = 1;
		}
		if (levels[curr_level].trigger[lasttrigger].trig_type == "end")
		{
			change_level = 2;
		}
		lasttrigger++
		lasttrigger_count = counter;
		
	}
}

function DoScript(string)
{
	eval(string);
}